#include "SortThread.h"


//---------------------------------------------------------------------------
//Metoda wywolywana do synchronizacji VCL
#include "Unit1.h"
void __fastcall TSortThread::SetListBoxItems(void)
{
/*
//Zapisywanie wynikow
OutputListBox->Color=OutputListBoxColor;
OutputListBox->Items->Clear();
for (int i=0; i<DataAmount; i++) OutputListBox->Items->Add(Data[i]);
OutputListBox->Refresh();
*/

if (SortMethod==smBubble)
	{
	Form1->ListBox2->Color=OutputListBoxColor;
	Form1->ListBox2->Items->Clear();
	for (int i=0; i<DataAmount; i++) Form1->ListBox2->Items->Add(Data[i]);
	Form1->ListBox2->Refresh();
	}
if (SortMethod==smSelection)
	{
	Form1->ListBox3->Color=OutputListBoxColor;
	Form1->ListBox3->Items->Clear();
	for (int i=0; i<DataAmount; i++) Form1->ListBox3->Items->Add(Data[i]);
	Form1->ListBox3->Refresh();
	}
if (SortMethod==smInsert)
	{
	Form1->ListBox4->Color=OutputListBoxColor;
	Form1->ListBox4->Items->Clear();
	for (int i=0; i<DataAmount; i++) Form1->ListBox4->Items->Add(Data[i]);
	Form1->ListBox4->Refresh();
	}
if (SortMethod==smQuick)
	{
	Form1->ListBox5->Color=OutputListBoxColor;
	Form1->ListBox5->Items->Clear();
	for (int i=0; i<DataAmount; i++) Form1->ListBox5->Items->Add(Data[i]);
	Form1->ListBox5->Refresh();
	}
}

//Konstruktor
TSortThread::TSortThread(sorttype* OriginalData, int _DataAmount,bool CreateSuspended)
:TThread(CreateSuspended),Data(NULL),OutputListBoxColor(clBtnFace)
{
//Ustawienia TThreat
FreeOnTerminate=true; //Usuwa z pamieci po zakonczeniu Execute

//Rezerwacja pamieci i kopiowanie danych
DataAmount=_DataAmount;
Data=(sorttype *)calloc(DataAmount,sizeof(sorttype));
for (int i=0; i<DataAmount; i++) Data[i]=OriginalData[i];
}

//Destruktor
__fastcall TSortThread::~TSortThread()
{
free(Data);
Data=NULL;
//ShowMessage("Wtek zakoczy dziaanie ("+(AnsiString)SortMethod+")");
}

//---------------------------------------------------------------------------
//Metoda uruchamiajaca sortowanie
#include "bubblesort.c"
#include "selectionsort.c"
#include "insertsort.c"
#include "quicksort.c"

void __fastcall TSortThread::Execute()
{
if (Data==0 || SortMethod==smNone) return;

//Sortowanie
switch (SortMethod)
	{
    case smBubble: bubblesort(Data,DataAmount); break;
    case smSelection: selectionsort(Data,DataAmount); break;
    case smInsert: insertsort(Data,DataAmount); break;
    case smQuick: quicksort(Data,DataAmount); break;
    }

/*
//Zapisywanie wynikow
OutputListBox->Color=OutputListBoxColor;
OutputListBox->Items->Clear();
for (int i=0; i<DataAmount; i++) OutputListBox->Items->Add(Data[i]);
OutputListBox->Refresh();
*/

Synchronize(SetListBoxItems);
}


